/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.toolkit.admin.result.images.VWImageLoader;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWAdminConfirmWithCheckBoxDialog
extends VWModalDialog
implements ItemListener {
    private boolean m_bCanceled = true;
    private boolean m_bOK = false;
    private boolean m_bCheckBox = true;
    private JTextArea m_infoTextArea = null;
    private JLabel m_warningIcon = null;
    private JButton m_okButton = new JButton(VWResource.s_OK);
    private JButton m_cancelButton = new JButton(VWResource.s_cancel);
    private JCheckBox m_checkBox = new JCheckBox();
    private int m_defButtonFlag;

    public VWAdminConfirmWithCheckBoxDialog(Frame parent, String dlgTitle, String msg, String checkBoxText, int defButtonFlag) {
        super(parent);
        this.m_defButtonFlag = defButtonFlag;
        this.setupLayout(dlgTitle, msg, checkBoxText);
    }

    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        if (state == 2) {
            this.m_bCheckBox = false;
        } else if (state == 1) {
            this.m_bCheckBox = true;
        }
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_infoTextArea.setFont(boldFont);
        }
        if (this.m_defButtonFlag == 2) {
            this.m_cancelButton.requestFocus();
        } else if (this.m_defButtonFlag == 0) {
            this.m_okButton.requestFocus();
        }
    }

    protected boolean isCanceled() {
        return this.m_bCanceled;
    }

    protected boolean isYes() {
        return this.m_bOK;
    }

    protected boolean isChecked() {
        return this.m_bCheckBox;
    }

    private void setupLayout(String dlgTitle, String msg, String checkBoxText) {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("385,245");
        if (dim == null) {
            dim = new Dimension(350, 220);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(dlgTitle);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        this.m_infoTextArea = new JTextArea(msg);
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        VWAccessibilityHelper.setAccessibility(this.m_infoTextArea, this, msg, msg);
        this.m_checkBox.setText(checkBoxText);
        this.m_checkBox.setSelected(true);
        this.m_checkBox.addItemListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_checkBox, this, VWResource.s_delegate, VWResource.s_delegate);
        this.m_checkBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_warningIcon = new JLabel(VWImageLoader.createImageIcon("warning.gif"));
        VWAccessibilityHelper.setAccessibility(this.m_warningIcon, this, VWResource.s_warningIcon, VWResource.s_warningIcon);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 3));
        iconPanel.add(this.m_warningIcon);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.m_infoTextArea, "First");
        panel.add((Component)this.m_checkBox, "Center");
        JPanel littlePanel = new JPanel();
        littlePanel.setLayout(new BorderLayout(10, 10));
        littlePanel.add((Component)panel, "Center");
        littlePanel.add((Component)iconPanel, "Before");
        mainPanel.add((Component)littlePanel, "First");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
        this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
        this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        mainPanel.add((Component)buttonPanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWAdminConfirmWithCheckBoxDialog.this.m_bCanceled = false;
                VWAdminConfirmWithCheckBoxDialog.this.m_bOK = true;
                VWAdminConfirmWithCheckBoxDialog.this.setVisible(false);
            }
        });
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWAdminConfirmWithCheckBoxDialog.this.m_bCanceled = true;
                VWAdminConfirmWithCheckBoxDialog.this.setVisible(false);
            }
        });
    }
}

